unit ClientUnit;

{
 Delphi Socket Client Demo
 Author : D. Claessens
 FREEWARE
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp, StdCtrls;

type
  TForm1 = class(TForm)
    ClSock: TClientSocket;
    Memo1: TMemo;
    btnconnect: TButton;
    btnDiscon: TButton;
    Button1: TButton;
    Edit1: TEdit;
    Edit3: TEdit;
    procedure btnconnectClick(Sender: TObject);
    procedure ClSockConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure btnDisconClick(Sender: TObject);
    procedure ClSockDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure Button1Click(Sender: TObject);
    procedure ClSockRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClSockError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
   
  end;

  procedure SockRead( Socket: TCustomWinSocket;
                        var pMem: Pointer;
                        var SizeRead: integer);
var
  Form1: TForm1;

implementation


{$R *.DFM}


//------------------------------------------
procedure SockRead( Socket     : TCustomWinSocket;
                   var pMem    : Pointer;
                   var SizeRead: integer);
var
 Stream    : TMemoryStream;
 BlockSize : integer;
begin
  // Win32 frequently calls with  length 0...
  if Socket.Receivelength > 0 then
  begin
    BlockSize := Socket.ReceiveLength;
    Stream    := TMemoryStream.Create;
    pMem      := AllocMem( BlockSize );
    // loop until all read
    while BlockSize > 0 do
    begin
      Socket.ReceiveBuf( pMem^, BlockSize ); // read block
      Stream.Write( pMem^, BlockSize );      // concat. to stream
      BlockSize := Socket.ReceiveLength;
      if BlockSize > 0 then                 // anymore blocks?
       ReAllocMem(pMem, BlockSize)          // prepare for next bloc
    end;
    Stream.Position := 0;
    ReAllocMem ( pMem, Stream.Size );     // now reallocate all blocks
    Stream.Read( pMem^, Stream.Size );    // copy > pointer memory
    SizeRead := Stream.Size;
    Stream.Free;
  end
  else begin
   pMem := nil;
   SizeRead := 0;
  end;
end;





//======================CLIENT=============================================
procedure TForm1.btnconnectClick(Sender: TObject);
begin
  clSock.Host := edit1.Text;
  clSock.Active := true;
end;

//=========================================================================
procedure TForm1.ClSockConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
 with Socket do
    Memo1.Lines.Add('connected to <' + RemoteHost+'> ['+RemoteAddress+']');
 button1.enabled := true;
end;

//----------------------------------------------
procedure TForm1.btnDisconClick(Sender: TObject);
begin
   ClSock.Close;
   button1.enabled := false;
end;

//------------------------------------------------
procedure TForm1.ClSockDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
 with Socket do
    Memo1.Lines.Add('disconnected from : <' + RemoteHost+'> ['+RemoteAddress+']');
 button1.enabled := false;

end;

//-------------------------------------------
procedure TForm1.Button1Click(Sender: TObject);
begin
  if ClSock.Active then
     ClSock.Socket.SendText( edit3.text + #13);
end;


//====================================================================
procedure TForm1.ClSockRead(Sender: TObject; Socket: TCustomWinSocket);
var
 sBuf      : string;
 pData     : pointer;
 Size      : integer;
begin
  SockRead( Socket, pData, Size );
  if Size > 0 then
  begin
   SetLength( sBuf, Size );
   Move( pData^, sBuf[1], Size);
   memo1.lines.add(sBuf);
   FreeMem(pData); //NEVER FORGET THIS, or you cause a memory leak!
  end;
end;

//=====================================================================
procedure TForm1.ClSockError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
   ErrorCode := 0;
   memo1.lines.add( 'IP-error :' + IntToStr(integer(ErrorEvent)));
end;

end.
